#include <12F683.H>
#device adc=10  // CAN en mode 10 bits
#FUSES NOWDT                    // No Watch Dog Timer 
#FUSES PUT                      // No Power Up Timer 
#FUSES MCLR                     // Master Clear      
#FUSES INTRC                    // Use internal R/C oscillator 
#use delay(internal=8000000)
#define SPI_MODE_0  (SPI_L_TO_H | SPI_XMIT_L_TO_H) //CPOL=0   CPHA=0 
#define SPI_MODE_1  (SPI_L_TO_H)                   //CPOL=0   CPHA=1 
#define SPI_MODE_2  (SPI_H_TO_L)                   //CPOL=1   CPHA=0 
#define SPI_MODE_3  (SPI_H_TO_L | SPI_XMIT_L_TO_H) //CPOL=1   CPHA=1 

#int_timer0
#define SPI_DO   PIN_A2  // data input output 
#define SPI_sclk  PIN_A3  // clock output 
#define SPI_CS    PIN_A1  // ship select
//
#use spi(DO=SPI_DO, CLK=SPI_SCLK, BITS=12, mode=3)
//
void send_data(int16 data) 
{ 
  
   output_low(SPI_CS);  // select the chip 
   delay_us(5); 
   spi_xfer(Data);          // send the new value to the DAC register 
   delay_us(5); 
   output_high(SPI_CS); // deselect the SPI data input 
   delay_us(5); 
  
 
 } 
 //
// void DAC_reset() 
 // { 
 
  //  output_high(SPI_sclk); 
 // } 
  //
 
int16 valeur=0;
float tension;

init_adc();
void adc()
{
   valeur = read_adc();
}


void main()
{
   int16 DACoutMV;
   setup_oscillator(OSC_8MHZ | OSC_INTRC); 
     setup_adc(no_analogs); 
   set_tris_a(101001);
   setup_timer_0 (RTCC_DIV_4|RTCC_INTERNAL);//fe=4096000/4/4/256=1kHz
   enable_interrupts(INT_TIMER0);
   setup_adc_ports( sAN0 );
   setup_adc(ADC_CLOCK_DIV_8);
   set_adc_channel( 0 );
   enable_interrupts(GLOBAL);
   while(true)
   {
       DACoutMV= 2000;      // value 0 to 4095 (0xfff) =  0 to 4.095 volts 
         send_data(Dacoutmv); // start a square wave 2 volts high 
         delay_ms(30);        // make the square wave 30ms long 
         DACoutMV= 0;         // set the DAC output back to zero using data 
         send_data(Dacoutmv); // end of 30ms square wave 
         delay_ms(100);       // wait 100ms before starting triangle wave 
         // start of triangle wave            
         for(DACOutMV=0x00;DACoutMV<0xfff;DACoutMV++)    
               send_data(Dacoutmv); 
         // end of triangle wave 
         delay_ms(30); // wait 30ms at the top 
          // dac_reset();  // reset everything back to zero 
         // 
        
     
   }
}
   

